/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.datagen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardDecks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import org.jetbrains.annotations.NotNull;

public class CardDeckProvider
implements class_2405 {
    private final FabricDataOutput output;
    private final Gson gson;

    public CardDeckProvider(FabricDataOutput output) {
        this.output = output;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cachedOutput) {
        return CompletableFuture.runAsync(() -> {
            Path outputPath = this.output.method_45971();
            String decksOutputPath = String.valueOf(outputPath) + File.separator + "data" + File.separator + "charta" + File.separator + "decks";
            CardDecks.DECKS.forEach((key, deck) -> {
                String path = key.method_12832() + ".json";
                Path fullPath = Path.of(decksOutputPath, path);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                HashingOutputStream hashedOutStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outStream);
                DataResult json = CardDeck.CODEC.encode(deck, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty());
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashedOutStream, StandardCharsets.UTF_8);){
                    writer.write(this.gson.toJson((JsonElement)json.getOrThrow()));
                    writer.flush();
                }
                catch (IOException e) {
                    Charta.LOGGER.error("Error writing stream for file: {}", (Object)fullPath, (Object)e);
                }
                try {
                    cachedOutput.method_43346(fullPath, outStream.toByteArray(), hashedOutStream.hash());
                }
                catch (IOException e) {
                    Charta.LOGGER.error("Error saving file: {}", (Object)fullPath, (Object)e);
                }
            });
        });
    }

    @NotNull
    public String method_10321() {
        return "CardDecks";
    }
}

